/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.bytecodecs.utils;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface Either<L, R> {
    public static <L, R> Either<L, R> ofLeft(L left) {
        return new Left(left);
    }

    public static <L, R> Either<L, R> ofRight(R right) {
        return new Right(right);
    }

    public static <T> T value(Either<T, T> either) {
        return either.map(Function.identity(), Function.identity());
    }

    public <T> T map(Function<L, T> var1, Function<R, T> var2);

    default public <F, S> Either<F, S> mapEither(Function<L, F> mapLeft, Function<R, S> mapRight) {
        return this.map(value -> Either.ofLeft(mapLeft.apply(value)), value -> Either.ofRight(mapRight.apply(value)));
    }

    default public <T> Either<T, R> mapLeft(Function<L, T> mapLeft) {
        return this.map(value -> Either.ofLeft(mapLeft.apply(value)), Either::ofRight);
    }

    default public <T> Either<L, T> mapRight(Function<R, T> mapRight) {
        return this.map(Either::ofLeft, value -> Either.ofRight(mapRight.apply(value)));
    }

    default public Either<L, R> ifLeft(Consumer<L> consumer) {
        this.left().ifPresent(consumer);
        return this;
    }

    default public Either<L, R> ifRight(Consumer<R> consumer) {
        this.right().ifPresent(consumer);
        return this;
    }

    default public Either<L, R> ifLeftOrElse(Consumer<L> consumer, Runnable orElse) {
        this.left().ifPresentOrElse(consumer, orElse);
        return this;
    }

    default public Either<L, R> ifRightOrElse(Consumer<R> consumer, Runnable orElse) {
        this.right().ifPresentOrElse(consumer, orElse);
        return this;
    }

    default public Optional<L> left() {
        return Optional.empty();
    }

    default public L leftOr(L value) {
        return this.left().orElse(value);
    }

    default public L leftOrThrow() {
        return this.left().orElseThrow();
    }

    default public Optional<R> right() {
        return Optional.empty();
    }

    default public R rightOr(R value) {
        return this.right().orElse(value);
    }

    default public R rightOrThrow() {
        return this.right().orElseThrow();
    }

    default public boolean isLeft() {
        return this.left().isPresent();
    }

    default public boolean isRight() {
        return this.right().isPresent();
    }

    public record Left<L, R>(L value) implements Either<L, R>
    {
        @Override
        public <T> T map(Function<L, T> mapLeft, Function<R, T> mapRight) {
            return mapLeft.apply(this.value);
        }

        @Override
        public Optional<L> left() {
            return Optional.of(this.value);
        }
    }

    public record Right<L, R>(R value) implements Either<L, R>
    {
        @Override
        public <T> T map(Function<L, T> mapLeft, Function<R, T> mapRight) {
            return mapRight.apply(this.value);
        }

        @Override
        public Optional<R> right() {
            return Optional.of(this.value);
        }
    }
}

